Imports System.Threading
Imports System.Drawing

Public Class Dice

  Private FValue As Integer = 1
  Private Shared FRolling As Integer = 0
  Private FColor As Color
  Private FRect As Rectangle
  Public Shared Done As New AutoResetEvent(False)

  Public Sub New()
    MyClass.New(New Rectangle(10, 10, 50, 50), Color.White)
  End Sub

  Public Sub New(ByVal Rect As Rectangle, ByVal color As Color)
    MyBase.New()
    FRect = Rect
    FColor = color
  End Sub

  Public Property Value() As Integer
    Get
      Return FValue
    End Get
    Set(ByVal Value As Integer)
      FValue = Value
    End Set
  End Property

  Public Sub Draw(ByVal Graphic As Graphics)
    DiceGraphic.Draw(Graphic, FValue, FRect, FColor)
  End Sub
End Class

Public Class DiceGraphic

  Public Shared Sub Draw(ByVal Graphic As Graphics, _
    ByVal Value As Integer, _
    ByVal Rect As Rectangle, ByVal Color As Color)

    Graphic.FillRectangle(New SolidBrush(Color), Rect)
    Graphic.DrawRectangle(Pens.Black, Rect)
    DrawDots(Graphic, GetRects(Value, Rect))

  End Sub


  Private Shared Function GetRects(ByVal Value As Integer, _
    ByVal Rect As Rectangle) As Rectangle()

    Dim One() As Rectangle = {GetRectangle(Rect, 1, 1)}
    Dim Two() As Rectangle = {GetRectangle(Rect, 0, 2), _
    GetRectangle(Rect, 2, 0)}

    Dim Three() As Rectangle = {GetRectangle(Rect, 0, 2), _
    GetRectangle(Rect, 1, 1), GetRectangle(Rect, 2, 0)}

    Dim Four() As Rectangle = {GetRectangle(Rect, 0, 0), _
      GetRectangle(Rect, 0, 2), GetRectangle(Rect, 2, 0), _
      GetRectangle(Rect, 2, 2)}

    Dim Five() As Rectangle = {GetRectangle(Rect, 0, 0), _
    GetRectangle(Rect, 1, 1), GetRectangle(Rect, 0, 2), _
    GetRectangle(Rect, 2, 0), GetRectangle(Rect, 2, 2)}

    Dim Six() As Rectangle = {GetRectangle(Rect, 0, 0), _
      GetRectangle(Rect, 0, 1), GetRectangle(Rect, 0, 2), _
      GetRectangle(Rect, 2, 0), GetRectangle(Rect, 2, 1), _
      GetRectangle(Rect, 2, 2)}

    Dim Rects As Rectangle()() = _
      {One, Two, Three, Four, Five, Six}

    Return Rects(Value - 1)

  End Function

  Protected Shared Function GetRectangle(ByVal Rect As Rectangle, _
    ByVal X As Integer, ByVal Y As Integer) As Rectangle

    Return New Rectangle(Rect.X + _
      (Rect.Width * X / 3), _
      Rect.Y + (Rect.Height * Y / 3), _
      GetDotSize(Rect).Width, GetDotSize(Rect).Height)
  End Function


  Protected Shared Function GetDotSize( _
    ByVal Rect As Rectangle) As Size

    Return New Size(Rect.Width / 3, Rect.Height / 3)
  End Function

  Private Shared Sub DrawDot(ByVal Graphic As Graphics, _
    ByVal Rect As Rectangle)

    Graphic.SmoothingMode = _
      Drawing.Drawing2D.SmoothingMode.AntiAlias

    Rect.Inflate(-3, -3)
    Graphic.FillEllipse(New SolidBrush(Color.Black), Rect)

  End Sub

  Private Shared Sub DrawDots(ByVal Graphic As Graphics, _
  ByVal Rects() As Rectangle)

    Dim I As Integer
    For I = 0 To Rects.Length - 1
      DrawDot(Graphic, Rects(I))
    Next

  End Sub

End Class


